using System;
using Borland.Eco.Services;
using Borland.Eco.UmlCodeAttributes;

namespace ChangeLogging
{
	[EcoSpace]
	[EcoSpacePackage(typeof(ChangeLogging.CoreClassesPackage))]
	public class ChangeLoggingEcoSpace: Borland.Eco.Handles.DefaultEcoSpace
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private void InitializeComponent()
		{
		}

		public ChangeLoggingEcoSpace(): base()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				Active = false;
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		private static ITypeSystemService typeSystemProvider;
		public static new ITypeSystemService GetTypeSystemService()
		{
		if (typeSystemProvider == null)
				lock(typeof(ChangeLoggingEcoSpace))
				{
					if (typeSystemProvider == null)
						typeSystemProvider = MakeTypeService(typeof(ChangeLoggingEcoSpace));
				}
			return typeSystemProvider;
		}
		protected override ITypeSystemService GetTypeSystemProvider()
		{
			return ChangeLoggingEcoSpace.GetTypeSystemService();
		}
		//
		// Services
		//
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)GetEcoService(typeof(IDirtyListService)); }
		}
		public IUndoService UndoService
		{
			get { return (IUndoService)GetEcoService(typeof(IUndoService)); }
		}
		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService)); }
		}
		//
		// Misc helper functions
		//
		public void UpdateDatabase()
		{
			if ((PersistenceService != null) && (DirtyListService != null))
			{
				PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
			}
		}
		//
		// Add user written methods here
		//

		public ChangeTrackingCache m_ChangeTrackingCache = new ChangeTrackingCache();

        // Install the ChangeTrackingCache
		public override void Initialize()
		{
		   base.Initialize();
		   m_ChangeTrackingCache.NextCache = FrontsidePolicy.Cache;
		   FrontsidePolicy.Cache = m_ChangeTrackingCache;
		}

	}
}
